#!/bin/bash
MODEL_PATH=$1
set -e # exit on error
# <DATA_FOLDER>docci/docci_ambiguity_test.5k.eval.jsonl
DATASET=docci_ambiguity_test.5k
pred_file=${MODEL_PATH}/${DATASET}/merge.jsonl

python inf_qwen_vl.py eval \
        --model-path ${MODEL_PATH} \
        --question-file <DATA_FOLDER>docci/${DATASET}.eval.jsonl \
        --image-folder <DATA_FOLDER>/ \
        --answer-file ${pred_file}

output_file=${MODEL_PATH}/${DATASET}/pred_probs_only_yes_or_no/merge.jsonl
python inf_qwen_vl.py get_pred_prob_only_yes_or_no \
        --model-path ${MODEL_PATH} \
        --question-file <DATA_FOLDER>docci/${DATASET}.eval.jsonl \
        --image-folder <DATA_FOLDER> \
        --pred_file ${pred_file} \
        --answer-file ${output_file} \
        --overwrite 

